/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class BrowseEffect
extends OneShotEffect {
    BrowseEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top five cards of your library, put one of them into your hand, and exile the rest";
    }

    private BrowseEffect(BrowseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrowseEffect copy() {
        return new BrowseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
            if (!cards.isEmpty()) {
                Card card;
                controller.lookAtCards(source, null, (Cards)cards, game);
                TargetCard target = new TargetCard(Zone.LIBRARY, new FilterCard("card to put in your hand"));
                if (controller.choose(Outcome.Benefit, (Cards)cards, target, source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
                    controller.moveCards(card, Zone.HAND, source, game);
                    cards.remove(card);
                }
                controller.moveCards((Cards)cards, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }
}

