/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BrudicladTelchorMyrToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class BrudicladTelchorEngineerEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("token you control");

    public BrudicladTelchorEngineerEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "create a 2/1 blue Phyrexian Myr artifact creature token. Then you may choose a token you control. If you do, each other token you control becomes a copy of that token";
    }

    private BrudicladTelchorEngineerEffect(BrudicladTelchorEngineerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrudicladTelchorEngineerEffect copy() {
        return new BrudicladTelchorEngineerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CreateTokenEffect effect = new CreateTokenEffect((Token)new BrudicladTelchorMyrToken(), 1);
        if (effect.apply(game, source)) {
            Permanent toCopyFromPermanent;
            TargetControlledPermanent target = new TargetControlledPermanent(0, 1, filter, true);
            target.withNotTarget(true);
            if (controller.chooseUse(this.outcome, "Select a token to copy?", source, game) && controller.choose(Outcome.Neutral, (Target)target, source, game) && (toCopyFromPermanent = game.getPermanent(target.getFirstTarget())) != null) {
                for (Permanent toCopyToPermanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, source.getControllerId(), game)) {
                    if (toCopyToPermanent.equals(toCopyFromPermanent)) continue;
                    game.copyPermanent(toCopyFromPermanent, toCopyToPermanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
                }
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

