/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BruenorBattlehammerBoostEffect
extends ContinuousEffectImpl {
    BruenorBattlehammerBoostEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "each creature you control gets +2/+0 for each Equipment attached to it";
    }

    private BruenorBattlehammerBoostEffect(BruenorBattlehammerBoostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public BruenorBattlehammerBoostEffect copy() {
        return new BruenorBattlehammerBoostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game)) {
            int equipped = permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).mapToInt(p -> p.hasSubtype(SubType.EQUIPMENT, game) ? 1 : 0).sum();
            permanent.addPower(2 * equipped);
        }
        return true;
    }
}

