/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.EquipAbility;
import mage.cards.b.BruenorBattlehammerWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BruenorBattlehammerCostEffect
extends CostModificationEffectImpl {
    BruenorBattlehammerCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.SET_COST);
        this.staticText = "you may pay {0} rather than pay the equip cost of the first equip ability you activate each turn.";
    }

    private BruenorBattlehammerCostEffect(BruenorBattlehammerCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof EquipAbility && source.isControlledBy(abilityToModify.getControllerId()) && !BruenorBattlehammerWatcher.checkPlayer(abilityToModify.getControllerId(), game);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        boolean applyReduce = false;
        if (game.inCheckPlayableState()) {
            applyReduce = true;
        } else {
            Player controller = game.getPlayer(abilityToModify.getControllerId());
            if (controller != null && controller.chooseUse(Outcome.PlayForFree, String.format("Pay {0} to equip instead %s?", abilityToModify.getManaCostsToPay().getText()), source, game)) {
                applyReduce = true;
            }
        }
        if (applyReduce) {
            abilityToModify.clearCosts();
            abilityToModify.clearManaCostsToPay();
            return true;
        }
        return false;
    }

    public BruenorBattlehammerCostEffect copy() {
        return new BruenorBattlehammerCostEffect(this);
    }
}

