/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BulwarkDamageEffect
extends OneShotEffect {
    BulwarkDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to target opponent, where X is the number of cards in your hand minus the number of cards in that player's hand";
    }

    private BulwarkDamageEffect(BulwarkDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public BulwarkDamageEffect copy() {
        return new BulwarkDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int amount;
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent != null && controller != null && (amount = controller.getHand().size() - opponent.getHand().size()) > 0) {
            opponent.damage(amount, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }
}

