/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.BurningCinderFuryOfCrimsonChaosFireCreatureGainControlEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BurningCinderFuryOfCrimsonChaosFireEffect
extends OneShotEffect {
    private UUID firstControllerId = null;

    public BurningCinderFuryOfCrimsonChaosFireEffect() {
        super(Outcome.Detriment);
        this.staticText = "that player choose one of their opponents. The chosen player gains control of that permanent at the beginning of the next end step";
    }

    private BurningCinderFuryOfCrimsonChaosFireEffect(BurningCinderFuryOfCrimsonChaosFireEffect effect) {
        super((OneShotEffect)effect);
        this.firstControllerId = effect.firstControllerId;
    }

    public BurningCinderFuryOfCrimsonChaosFireEffect copy() {
        return new BurningCinderFuryOfCrimsonChaosFireEffect(this);
    }

    public void setFirstControllerId(UUID newId) {
        this.firstControllerId = newId;
    }

    public boolean apply(Game game, Ability source) {
        Player tappingPlayer = game.getPlayer(this.firstControllerId);
        Permanent permanentToControl = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (tappingPlayer != null && permanentToControl != null) {
            Player chosenOpponent;
            FilterPlayer filter = new FilterPlayer("opponent to control " + permanentToControl.getIdName());
            ArrayList<PlayerIdPredicate> opponentPredicates = new ArrayList<PlayerIdPredicate>();
            for (UUID opponentId : game.getOpponents(this.firstControllerId)) {
                opponentPredicates.add(new PlayerIdPredicate(opponentId));
            }
            filter.add(Predicates.or(opponentPredicates));
            TargetPlayer target = new TargetPlayer(1, 1, true, filter);
            target.setTargetController(this.firstControllerId);
            target.setAbilityController(source.getControllerId());
            if (tappingPlayer.chooseTarget(this.outcome, (Target)target, source, game) && (chosenOpponent = game.getPlayer(target.getFirstTarget())) != null) {
                game.informPlayers(tappingPlayer.getLogName() + " chose " + chosenOpponent.getLogName() + " to gain control of " + permanentToControl.getLogName() + " at the beginning of the next end step");
                BurningCinderFuryOfCrimsonChaosFireCreatureGainControlEffect effect = new BurningCinderFuryOfCrimsonChaosFireCreatureGainControlEffect(Duration.Custom, chosenOpponent.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanentToControl.getId(), game));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
                return true;
            }
        }
        return false;
    }
}

