/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class BurningOfXinyeEffect
extends OneShotEffect {
    private static final FilterControlledLandPermanent filter = new FilterControlledLandPermanent();

    BurningOfXinyeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "You destroy four lands you control, then target opponent destroys four lands they control";
    }

    private BurningOfXinyeEffect(BurningOfXinyeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        boolean abilityApplied = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            abilityApplied |= this.playerDestroys(game, source, controller);
        }
        if ((opponent = game.getPlayer(source.getFirstTarget())) != null) {
            abilityApplied |= this.playerDestroys(game, source, opponent);
        }
        return abilityApplied;
    }

    private boolean playerDestroys(Game game, Ability source, Player player) {
        boolean abilityApplied = false;
        int realCount = game.getBattlefield().countAll((FilterPermanent)filter, player.getId(), game);
        int amount = Math.min(4, realCount);
        TargetControlledPermanent target = new TargetControlledPermanent(amount, amount, (FilterControlledPermanent)filter, true);
        if (amount > 0 && target.canChoose(player.getId(), source, game) && player.choose(Outcome.DestroyPermanent, (Target)target, source, game)) {
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                abilityApplied |= permanent.destroy(source, game, false);
            }
        }
        return abilityApplied;
    }

    public BurningOfXinyeEffect copy() {
        return new BurningOfXinyeEffect(this);
    }
}

