/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;
import mage.target.common.TargetOpponent;

class BurningRuneDemonEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards not named Burning-Rune Demon that have different names");

    public BurningRuneDemonEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for exactly two cards not named Burning-Rune Demon that have different names. If you do, reveal those cards. An opponent chooses one of them. Put the chosen card into your hand and the other into your graveyard, then shuffle";
    }

    private BurningRuneDemonEffect(BurningRuneDemonEffect effect) {
        super((OneShotEffect)effect);
    }

    public BurningRuneDemonEffect copy() {
        return new BurningRuneDemonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardWithDifferentNameInLibrary targetCardInLibrary;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.searchLibrary((TargetCardInLibrary)(targetCardInLibrary = new TargetCardWithDifferentNameInLibrary(2, 2, filter)), source, game)) {
            CardsImpl cards = new CardsImpl((Collection)targetCardInLibrary.getTargets());
            if (!cards.isEmpty()) {
                Player opponent;
                controller.revealCards(source, (Cards)cards, game);
                Set opponents = game.getOpponents(controller.getId());
                if (opponents.size() == 1) {
                    opponent = game.getPlayer((UUID)opponents.iterator().next());
                } else {
                    TargetOpponent targetOpponent = new TargetOpponent(true);
                    controller.chooseTarget(Outcome.Detriment, (Target)targetOpponent, source, game);
                    opponent = game.getPlayer(targetOpponent.getFirstTarget());
                }
                if (opponent != null) {
                    TargetCard targetCard = new TargetCard(Zone.LIBRARY, StaticFilters.FILTER_CARD);
                    targetCard.withChooseHint("Card to go to opponent's hand (other goes to graveyard)");
                    opponent.chooseTarget(this.outcome, (Cards)cards, targetCard, source, game);
                    Card cardToHand = game.getCard(targetCard.getFirstTarget());
                    if (cardToHand != null) {
                        controller.moveCardToHandWithInfo(cardToHand, source, game, true);
                        cards.remove(cardToHand);
                    }
                    if (!cards.isEmpty()) {
                        controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
                    }
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)new NamePredicate("Burning-Rune Demon")));
    }
}

