/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BurningTreeShamanTriggeredAbility
extends TriggeredAbilityImpl {
    BurningTreeShamanTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)StaticValue.get((int)1), true, "that player", true));
    }

    private BurningTreeShamanTriggeredAbility(BurningTreeShamanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BurningTreeShamanTriggeredAbility copy() {
        return new BurningTreeShamanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackAbility stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId());
        if (stackAbility != null && stackAbility.isNonManaActivatedAbility()) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a player activates an ability that isn't a mana ability, {this} deals 1 damage to that player.";
    }
}

