/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BushmeatPoacherEffect
extends OneShotEffect {
    BushmeatPoacherEffect() {
        super(Outcome.Benefit);
        this.staticText = "you gain life equal to the sacrificed creature's toughness. Draw a card";
    }

    private BushmeatPoacherEffect(BushmeatPoacherEffect effect) {
        super((OneShotEffect)effect);
    }

    public BushmeatPoacherEffect copy() {
        return new BushmeatPoacherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        SacrificeTargetCost cost = source.getCosts().stream().filter(SacrificeTargetCost.class::isInstance).map(SacrificeTargetCost.class::cast).findFirst().orElse(null);
        if (cost == null) {
            return false;
        }
        Permanent permanent = (Permanent)cost.getPermanents().get(0);
        if (permanent == null) {
            return false;
        }
        int amount = permanent.getToughness().getValue();
        if (amount > 0) {
            player.gainLife(amount, game, source);
        }
        return player.drawCards(1, source, game) > 0;
    }
}

