/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.predicate.mageobject.AdventurePredicate;
import mage.game.Game;
import mage.players.Player;

class SeekThrillsEffect
extends OneShotEffect {
    SeekThrillsEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill seven cards. Then put all cards that have an Adventure from among the milled cards into your hand.";
    }

    private SeekThrillsEffect(SeekThrillsEffect effect) {
        super((OneShotEffect)effect);
    }

    public SeekThrillsEffect copy() {
        return new SeekThrillsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Cards cards = player.millCards(7, source, game);
        cards.retainZone(Zone.GRAVEYARD, game);
        for (Card card : cards.getCards(game)) {
            if (AdventurePredicate.instance.apply((MageObject)card, game)) continue;
            cards.remove(card);
        }
        player.moveCardsToHandWithInfo(cards, source, game, true);
        return true;
    }
}

