/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.JunkToken;
import mage.game.permanent.token.Token;

class CAMPEffect
extends OneShotEffect {
    private final Mana mana;

    CAMPEffect(Mana mana) {
        super(Outcome.Benefit);
        this.mana = mana.copy();
    }

    private CAMPEffect(CAMPEffect effect) {
        super((OneShotEffect)effect);
        this.mana = effect.mana;
    }

    public CAMPEffect copy() {
        return new CAMPEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (target == null) {
            return false;
        }
        ObjectColor targetColor = target.getColor(game);
        if (this.mana.getWhite() > 0 && targetColor.isWhite() || this.mana.getBlue() > 0 && targetColor.isBlue() || this.mana.getBlack() > 0 && targetColor.isBlack() || this.mana.getRed() > 0 && targetColor.isRed() || this.mana.getGreen() > 0 && targetColor.isGreen()) {
            return new CreateTokenEffect((Token)new JunkToken()).apply(game, source);
        }
        return false;
    }
}

