/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CabarettiAscendencyEffect
extends OneShotEffect {
    CabarettiAscendencyEffect() {
        super(Outcome.DrawCard);
        this.staticText = "look at the top card of your library. If it's a creature or planeswalker card, you may reveal it and put it into your hand. If you don't put the card into your hand, you may put it on the bottom of your library";
    }

    private CabarettiAscendencyEffect(CabarettiAscendencyEffect effect) {
        super((OneShotEffect)effect);
    }

    public CabarettiAscendencyEffect copy() {
        return new CabarettiAscendencyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        MageObject sourceObject = source.getSourceObject(game);
        String objectName = sourceObject == null ? "Cabaretti Ascendency" : sourceObject.getIdName();
        controller.lookAtCards(objectName, card, game);
        if ((card.isCreature(game) || card.isPlaneswalker(game)) && controller.chooseUse(Outcome.DrawCard, "Reveal " + card.getIdName() + " and put it in your hand?", source, game)) {
            controller.revealCards(source, (Cards)new CardsImpl(card), game);
            controller.moveCards(card, Zone.HAND, source, game);
        } else if (controller.chooseUse(Outcome.Neutral, "Put " + card.getIdName() + " on the bottom of your library?", source, game)) {
            controller.putCardsOnBottomOfLibrary(card, game, source);
        }
        return true;
    }
}

