/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CommanderGreatestManaValue;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureSourceEffect;
import mage.abilities.keyword.ReachAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;

class CactusPreserveEffect
extends OneShotEffect {
    CactusPreserveEffect() {
        super(Outcome.BecomeCreature);
        this.staticText = "Until end of turn, {this} becomes an X/X green Plant creature with reach, where X is the greatest mana value among your commanders. It's still a land.";
    }

    private CactusPreserveEffect(CactusPreserveEffect effect) {
        super((OneShotEffect)effect);
    }

    public CactusPreserveEffect copy() {
        return new CactusPreserveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = CommanderGreatestManaValue.instance.calculate(game, source, (Effect)this);
        game.addEffect((ContinuousEffect)new BecomesCreatureSourceEffect((Token)new CreatureToken(xValue, xValue, "X/X green Plant creature with reach, where X is the greatest mana value among your commanders").withColor("G").withSubType(SubType.PLANT).withAbility((Ability)ReachAbility.getInstance()), CardType.LAND, Duration.EndOfTurn), source);
        return true;
    }
}

