/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class CaitSithFortuneTellerEffect
extends OneShotEffect {
    CaitSithFortuneTellerEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry 1, then exile the top card of your library. You may play that card this turn. When you exile a card this way, target creature you control gets +X/+0 until end of turn, where X is that card's mana value";
    }

    private CaitSithFortuneTellerEffect(CaitSithFortuneTellerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CaitSithFortuneTellerEffect copy() {
        return new CaitSithFortuneTellerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.scry(1, source, game);
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return true;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new BoostTargetEffect(card.getManaValue(), 0), false);
        ability.addTarget((Target)new TargetControlledCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

