/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CalamityBearerEffect
extends ReplacementEffectImpl {
    CalamityBearerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a Giant source you control would deal damage to a permanent or player, it deals double that damage to that permanent or player instead";
    }

    private CalamityBearerEffect(CalamityBearerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CalamityBearerEffect copy() {
        return new CalamityBearerEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getAmount() > 0 && source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
            Object sourceObject = sourcePermanent == null ? game.getObject(event.getSourceId()) : sourcePermanent;
            return sourceObject != null && sourceObject.hasSubtype(SubType.GIANT, game);
        }
        return false;
    }
}

