/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CalixGuidedByFateEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledEnchantmentPermanent("nonlegendary enchantment you control");

    CalixGuidedByFateEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of a nonlegendary enchantment you control";
    }

    private CalixGuidedByFateEffect(CalixGuidedByFateEffect effect) {
        super((OneShotEffect)effect);
    }

    public CalixGuidedByFateEffect copy() {
        return new CalixGuidedByFateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && new CreateTokenCopyTargetEffect().setSavedPermanent(permanent).apply(game, source);
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
    }
}

