/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CallForAidCantAttackThatPlayerEffect
extends RestrictionEffect {
    CallForAidCantAttackThatPlayerEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
    }

    private CallForAidCantAttackThatPlayerEffect(CallForAidCantAttackThatPlayerEffect effect) {
        super((RestrictionEffect)effect);
    }

    public CallForAidCantAttackThatPlayerEffect copy() {
        return new CallForAidCantAttackThatPlayerEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return Objects.equals(source.getControllerId(), permanent.getControllerId());
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null || attacker == null) {
            return true;
        }
        return !this.getTargetPointer().getTargets(game, source).contains(defenderId);
    }
}

