/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CallForAidYouCantSacrificeEffect
extends ContinuousEffectImpl {
    private final UUID playerId;
    private final FilterPermanent filter;

    CallForAidYouCantSacrificeEffect(UUID playerId, FilterPermanent filter) {
        super(Duration.EndOfTurn, Layer.RulesEffects, SubLayer.NA, Outcome.Benefit);
        this.playerId = playerId;
        this.filter = filter;
    }

    private CallForAidYouCantSacrificeEffect(CallForAidYouCantSacrificeEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.playerId = effect.playerId;
        this.filter = effect.filter;
    }

    public CallForAidYouCantSacrificeEffect copy() {
        return new CallForAidYouCantSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            if (!permanent.getControllerId().equals(this.playerId)) continue;
            permanent.setCanBeSacrificed(false);
        }
        return true;
    }
}

