/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CallTheSpiritDragonsEffect
extends OneShotEffect {
    private static final List<FilterPermanent> filters = new ArrayList<FilterPermanent>();

    CallTheSpiritDragonsEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each color, put a +1/+1 counter on a Dragon you control of that color. If you put +1/+1 counters on five Dragons this way, you win the game";
    }

    private CallTheSpiritDragonsEffect(CallTheSpiritDragonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public CallTheSpiritDragonsEffect copy() {
        return new CallTheSpiritDragonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        HashSet<UUID> dragons = new HashSet<UUID>();
        for (FilterPermanent filter : filters) {
            if (!game.getBattlefield().contains(filter, source, game, 1)) continue;
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            player.choose(Outcome.BoostCreature, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null || !permanent.addCounters(CounterType.P1P1.createInstance(), source, game)) continue;
            dragons.add(permanent.getId());
        }
        if (dragons.size() >= 5) {
            player.won(game);
        }
        return !dragons.isEmpty();
    }

    static {
        for (ObjectColor color : ObjectColor.getAllColors()) {
            FilterControlledPermanent filter = new FilterControlledPermanent(SubType.DRAGON, color.getDescription() + " Dragon you control");
            filter.add((Predicate)new ColorPredicate(color));
            filters.add((FilterPermanent)filter);
        }
    }
}

