/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class CallToTheKindredEffect
extends OneShotEffect {
    CallToTheKindredEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "look at the top five cards of your library. If you do, you may put a creature card that shares a creature type with enchanted creature from among them onto the battlefield, then you put the rest of those cards on the bottom of your library in any order";
    }

    private CallToTheKindredEffect(CallToTheKindredEffect effect) {
        super((OneShotEffect)effect);
    }

    public CallToTheKindredEffect copy() {
        return new CallToTheKindredEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null || controller == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent creature = game.getPermanent(enchantment.getAttachedTo());
        if (creature == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 5));
        FilterCreatureCard filter = new FilterCreatureCard();
        filter.add((Predicate)new SharesCreatureTypePredicate(creature));
        if (cards.count((FilterCard)filter, game) > 0) {
            TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)filter);
            controller.choose(Outcome.PutCreatureInPlay, (Cards)cards, (TargetCard)target, source, game);
            Card card = cards.get(target.getFirstTarget(), game);
            if (card != null) {
                cards.remove(card);
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
        }
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        return true;
    }
}

