/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class CallToTheVoidEffect
extends OneShotEffect {
    CallToTheVoidEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly chooses a creature they control and a creature they don't control. Then those choices are revealed. Destroy each creature chosen this way";
    }

    private CallToTheVoidEffect(CallToTheVoidEffect effect) {
        super((OneShotEffect)effect);
    }

    public CallToTheVoidEffect copy() {
        return new CallToTheVoidEffect(this);
    }

    private void chooseCreature(Map<String, List<String>> map, Set<Permanent> permanents, FilterPermanent filter, Player player, Ability source, Game game) {
        if (game.getBattlefield().count(filter, player.getId(), source, game) > 0) {
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                map.computeIfAbsent(player.getLogName(), x -> new ArrayList()).add(permanent.getLogName());
                permanents.add(permanent);
            }
        }
    }

    public boolean apply(Game game, Ability source) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        HashSet<Permanent> permanents = new HashSet<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            this.chooseCreature(map, permanents, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player, source, game);
            this.chooseCreature(map, permanents, (FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL, player, source, game);
        }
        map.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty()).map(entry -> (String)entry.getKey() + " has chosen " + CardUtil.concatWithAnd((List)((List)entry.getValue()))).forEach(arg_0 -> ((Game)game).informPlayers(arg_0));
        for (Permanent permanent : permanents) {
            permanent.destroy(source, game);
        }
        return true;
    }
}

