/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;

class CallerOfTheClawWatcher
extends Watcher {
    private int creaturesCount = 0;

    public CallerOfTheClawWatcher() {
        super(WatcherScope.PLAYER);
        this.condition = true;
    }

    public int getCreaturesCount() {
        return this.creaturesCount;
    }

    public void watch(GameEvent event, Game game) {
        Permanent card;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).isDiesEvent() && (card = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && card.isOwnedBy(this.controllerId) && card.isCreature(game) && !(card instanceof PermanentToken)) {
            ++this.creaturesCount;
        }
    }

    public void reset() {
        super.reset();
        this.creaturesCount = 0;
    }
}

