/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.CostAdjuster;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.cards.c.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

enum CallerOfTheHuntAdjuster implements CostAdjuster
{
    instance;


    public void prepareCost(Ability ability, Game game) {
        if (game.inCheckPlayableState()) {
            return;
        }
        Player controller = game.getPlayer(ability.getControllerId());
        if (controller == null) {
            return;
        }
        MageObject sourceObject = game.getObject(ability.getSourceId());
        if (sourceObject == null) {
            return;
        }
        HashMap usedSubTypeStats = new HashMap();
        game.getBattlefield().getActivePermanents(ability.getControllerId(), game).stream().map(permanent -> permanent.getSubtype(game)).flatMap(Collection::stream).distinct().forEach(subType -> {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)subType.getPredicate());
            int amount = new PermanentsOnBattlefieldCount((FilterPermanent)filter).calculate(game, ability, null);
            usedSubTypeStats.put(subType, amount);
        });
        int maxAmount = 0;
        SubType maxSubType = null;
        for (Map.Entry entry : usedSubTypeStats.entrySet()) {
            if ((Integer)entry.getValue() <= maxAmount) continue;
            maxSubType = (SubType)entry.getKey();
            maxAmount = (Integer)entry.getValue();
        }
        if (controller.isComputer()) {
            game.getState().setValue(sourceObject.getId() + "_type", (Object)maxSubType);
        } else {
            ChooseCreatureTypeEffect effect = new ChooseCreatureTypeEffect(Outcome.Benefit);
            effect.apply(game, ability);
        }
        SubType typeChoice = (SubType)game.getState().getValue(sourceObject.getId() + "_type");
        if (typeChoice == null) {
            return;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent("chosen creature type");
        filter.add((Predicate)typeChoice.getPredicate());
        SetBasePowerToughnessSourceEffect effectPowerToughness = new SetBasePowerToughnessSourceEffect((DynamicValue)new PermanentsOnBattlefieldCount((FilterPermanent)filter));
        effectPowerToughness.setText("");
        SimpleStaticAbility setPT = new SimpleStaticAbility(Zone.ALL, (Effect)effectPowerToughness);
        GainAbilityTargetEffect gainAbility = new GainAbilityTargetEffect((Ability)setPT, Duration.EndOfGame);
        gainAbility.setTargetPointer((TargetPointer)new FixedTarget(ability.getSourceId()));
        game.getState().addEffect((ContinuousEffect)gainAbility, ability);
    }
}

