/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CallousDeceiverEffect
extends OneShotEffect {
    CallousDeceiverEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Reveal the top card of your library. If it's a land card, {this} gets +1/+0 and gains flying until end of turn";
    }

    private CallousDeceiverEffect(CallousDeceiverEffect effect) {
        super((OneShotEffect)effect);
    }

    public CallousDeceiverEffect copy() {
        return new CallousDeceiverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl cards = new CardsImpl();
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                cards.add(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                if (card.isLand(game)) {
                    game.addEffect((ContinuousEffect)new BoostSourceEffect(1, 0, Duration.EndOfTurn), source);
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn), source);
                }
            }
            return true;
        }
        return false;
    }
}

