/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.BlockerDeclaredEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.RandomUtil;

class CamouflageEffect
extends ContinuousRuleModifyingEffectImpl {
    CamouflageEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit, false, false);
        this.staticText = "This turn, instead of declaring blockers, each defending player chooses any number of creatures they control and divides them into a number of piles equal to the number of attacking creatures for whom that player is the defending player. Creatures those players control that can block additional creatures may likewise be put into additional piles. Assign each pile to a different one of those attacking creatures at random. Each creature in a pile that can block the creature that pile is assigned to does so";
    }

    private CamouflageEffect(CamouflageEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CamouflageEffect copy() {
        return new CamouflageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARING_BLOCKERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<UUID, Object> masterMap = new HashMap<UUID, Object>();
            for (UUID defenderId : game.getCombat().getPlayerDefenders(game)) {
                Player defender = game.getPlayer(defenderId);
                if (defender == null) continue;
                ArrayList masterList = new ArrayList();
                int attackerCount = 0;
                for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                    if (!combatGroup.getDefendingPlayerId().equals(defenderId)) continue;
                    attackerCount += combatGroup.getAttackers().size();
                }
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterCreaturePermanent(), defenderId, game)) {
                    permanent.setBlocking(0);
                }
                boolean declinedChoice = false;
                while (masterList.size() < attackerCount) {
                    ArrayList newPile = new ArrayList();
                    if (!declinedChoice) {
                        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creatures you control not yet assigned to a pile");
                        Iterator iterator = masterList.iterator();
                        while (iterator.hasNext()) {
                            List list = (List)iterator.next();
                            ArrayList<Permanent> spentBlockers = new ArrayList<Permanent>();
                            for (Permanent possibleBlocker : list) {
                                if (possibleBlocker.getMaxBlocks() <= 0 || possibleBlocker.getBlocking() < possibleBlocker.getMaxBlocks()) continue;
                                spentBlockers.add(possibleBlocker);
                            }
                            filter.add(Predicates.not((Predicate)new PermanentReferenceInCollectionPredicate(spentBlockers, game)));
                        }
                        if (defender.chooseUse(Outcome.Neutral, "Make a new blocker pile? If not, all remaining piles stay empty. (remaining piles: " + (attackerCount - masterList.size()) + ')', source, game)) {
                            TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
                            if (target.canChoose(defenderId, source, game) && defender.chooseTarget(Outcome.Neutral, (Target)target, source, game)) {
                                for (UUID creatureId : target.getTargets()) {
                                    Permanent creature = game.getPermanent(creatureId);
                                    if (creature == null) continue;
                                    creature.setBlocking(creature.getBlocking() + 1);
                                    newPile.add(creature);
                                }
                            }
                        } else {
                            declinedChoice = true;
                        }
                    }
                    masterList.add(newPile);
                    StringBuilder sb = new StringBuilder("Blocker pile of ").append(defender.getLogName()).append(" (no. " + masterList.size() + "): ");
                    int i = 0;
                    Iterator iterator = newPile.iterator();
                    while (iterator.hasNext()) {
                        Permanent permanent = (Permanent)iterator.next();
                        sb.append(permanent.getLogName());
                        if (++i >= newPile.size()) continue;
                        sb.append(", ");
                    }
                    game.informPlayers(sb.toString());
                }
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterCreaturePermanent(), defenderId, game)) {
                    permanent.setBlocking(0);
                }
                masterMap.put(defenderId, masterList);
            }
            if (!masterMap.isEmpty()) {
                for (UUID playerId : masterMap.keySet()) {
                    ArrayList<Permanent> available = new ArrayList<Permanent>();
                    for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                        if (!combatGroup.getDefendingPlayerId().equals(playerId)) continue;
                        for (UUID attackerId : combatGroup.getAttackers()) {
                            Permanent permanent = game.getPermanent(attackerId);
                            if (permanent == null || !permanent.isCreature(game)) continue;
                            available.add(permanent);
                        }
                    }
                    List allPiles = (List)masterMap.get(playerId);
                    HashSet<UUID> blockerIds = new HashSet<UUID>();
                    for (List pile : allPiles) {
                        if (available.isEmpty()) break;
                        int randomAttacker = RandomUtil.nextInt((int)available.size());
                        Permanent attacker = (Permanent)available.get(randomAttacker);
                        if (attacker == null) continue;
                        available.remove(randomAttacker);
                        for (Permanent blocker : pile) {
                            CombatGroup group = game.getCombat().findGroup(attacker.getId());
                            if (group == null || !blocker.canBlock(attacker.getId(), game) || blocker.getMaxBlocks() != 0 && group.getAttackers().size() > blocker.getMaxBlocks()) continue;
                            blockerIds.add(blocker.getId());
                            boolean notYetBlocked = group.getBlockers().isEmpty();
                            group.addBlockerToGroup(blocker.getId(), blocker.getControllerId(), game);
                            game.getCombat().addBlockingGroup(blocker.getId(), attacker.getId(), blocker.getControllerId(), game);
                            if (notYetBlocked) {
                                game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CREATURE_BLOCKED, (UUID)attacker.getId(), (Ability)source, null));
                            }
                            game.fireEvent((GameEvent)new BlockerDeclaredEvent(attacker.getId(), blocker.getId(), blocker.getControllerId()));
                        }
                    }
                    for (UUID blockerId : blockerIds) {
                        game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.CREATURE_BLOCKS, (UUID)blockerId, (Ability)source, null));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

