/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.players.Player;

class CampfireEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard();

    CampfireEffect() {
        super(Outcome.Benefit);
        this.staticText = "put all commanders you own from the command zone and from your graveyard into your hand";
    }

    private CampfireEffect(CampfireEffect effect) {
        super((OneShotEffect)effect);
    }

    public CampfireEffect copy() {
        return new CampfireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getCommanderCardsFromCommandZone(player, CommanderCardType.ANY));
        cards.addAllCards((Collection)player.getGraveyard().getCards(filter, game));
        player.moveCards((Cards)cards, Zone.HAND, source, game);
        return true;
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
    }
}

