/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CannibalizeEffect
extends OneShotEffect {
    CannibalizeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose two target creatures controlled by the same player. Exile one of the creatures and put two +1/+1 counters on the other";
    }

    private CannibalizeEffect(CannibalizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CannibalizeEffect copy() {
        return new CannibalizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        switch (permanents.size()) {
            case 0: {
                return false;
            }
            case 1: {
                Permanent permanent = (Permanent)permanents.get(0);
                if (player.chooseUse(this.outcome, "Exile " + permanent.getIdName() + " or put two +1/+1 counters on it?", null, "Exile", "Add counters", source, game)) {
                    player.moveCards((Card)permanent, Zone.EXILED, source, game);
                } else {
                    permanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
                }
                return true;
            }
        }
        Permanent permanent1 = (Permanent)permanents.get(0);
        Permanent permanent2 = (Permanent)permanents.get(1);
        if (player.chooseUse(this.outcome, "Exile " + permanent1.getIdName() + " or " + permanent2.getIdName() + '?', "The other creature will get two +1/+1 counters", "Exile " + permanent1.getIdName(), "Exile " + permanent2.getIdName(), source, game)) {
            player.moveCards((Card)permanent1, Zone.EXILED, source, game);
            permanent2.addCounters(CounterType.P1P1.createInstance(2), source, game);
        } else {
            player.moveCards((Card)permanent2, Zone.EXILED, source, game);
            permanent1.addCounters(CounterType.P1P1.createInstance(2), source, game);
        }
        return true;
    }
}

