/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeOpponentsEffect;
import mage.abilities.effects.common.discard.DiscardEachPlayerEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class CapitalPunishmentEffect
extends OneShotEffect {
    CapitalPunishmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Council's dilemma</i> &mdash; Starting with you, each player votes for death or taxes. Each opponent sacrifices a creature for each death vote and discards a card for each taxes vote";
    }

    private CapitalPunishmentEffect(CapitalPunishmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public CapitalPunishmentEffect copy() {
        return new CapitalPunishmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TwoChoiceVote vote = new TwoChoiceVote("Death (sacrifice creature)", "Taxes (discard card)", Outcome.Detriment);
        vote.doVotes(source, game);
        int deathCount = vote.getVoteCount((Object)true);
        int taxesCount = vote.getVoteCount((Object)false);
        if (deathCount > 0) {
            new SacrificeOpponentsEffect(deathCount, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE).apply(game, source);
        }
        if (taxesCount > 0) {
            new DiscardEachPlayerEffect((DynamicValue)StaticValue.get((int)taxesCount), false, TargetController.OPPONENT).apply(game, source);
        }
        return true;
    }
}

