/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class CapriciousHellraiserEffect
extends OneShotEffect {
    CapriciousHellraiserEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile three cards at random from your graveyard. Choose a noncreature, nonland card from among them and copy it. You may cast the copy without paying its mana cost";
    }

    private CapriciousHellraiserEffect(CapriciousHellraiserEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsInGraveyard = new CardsImpl(controller.getGraveyard().getCards(game));
            CardsImpl toExile = new CardsImpl();
            CardsImpl cardsToChooseFrom = new CardsImpl();
            for (int i = 0; i < 3; ++i) {
                Card card = cardsInGraveyard.getRandom(game);
                if (card == null) continue;
                toExile.add(card);
                cardsInGraveyard.remove(card);
                if (card.isCreature(game) || card.isLand(game)) continue;
                cardsToChooseFrom.add(card);
            }
            controller.moveCards((Cards)toExile, Zone.EXILED, source, game);
            if (!cardsToChooseFrom.isEmpty()) {
                TargetCard targetCard = new TargetCard(1, Zone.EXILED, StaticFilters.FILTER_CARD);
                controller.choose(Outcome.Copy, (Cards)cardsToChooseFrom, targetCard, source, game);
                Card cardToCopy = game.getCard((UUID)targetCard.getTargets().get(0));
                if (cardToCopy == null) {
                    return true;
                }
                if (!controller.chooseUse(this.outcome, "Cast copy of " + cardToCopy.getName() + " without paying its mana cost?", source, game)) {
                    return true;
                }
                Card copiedCard = game.copyCard(cardToCopy, source, controller.getId());
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
                controller.cast(controller.chooseAbilityForCast(copiedCard, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
            }
            return true;
        }
        return false;
    }

    public CapriciousHellraiserEffect copy() {
        return new CapriciousHellraiserEffect(this);
    }
}

