/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.other.PlayerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class CapricopianEffect
extends OneShotEffect {
    CapricopianEffect() {
        super(Outcome.Benefit);
    }

    private CapricopianEffect(CapricopianEffect effect) {
        super((OneShotEffect)effect);
    }

    public CapricopianEffect copy() {
        return new CapricopianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player == null || permanent == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Reselect attacker for " + permanent.getIdName() + "?", source, game)) {
            return false;
        }
        FilterPlayer filterPlayer = new FilterPlayer();
        filterPlayer.add(Predicates.not((Predicate)new PlayerIdPredicate(permanent.getControllerId())));
        filterPlayer.add(Predicates.not((Predicate)new PlayerIdPredicate(game.getCombat().getDefenderId(permanent.getId()))));
        TargetPlayer targetPlayer = new TargetPlayer(0, 1, true, filterPlayer);
        player.choose(this.outcome, (Target)targetPlayer, source, game);
        Player newPlayer = game.getPlayer(targetPlayer.getFirstTarget());
        if (newPlayer == null) {
            return false;
        }
        game.getCombat().removeAttacker(permanent.getId(), game);
        return game.getCombat().addAttackingCreature(permanent.getId(), game, newPlayer.getId());
    }
}

