/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.costs.EarlyTargetCost;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.AttachedToSourcePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CaptainAmericaFirstAvengerUnattachCost
extends CostImpl
implements EarlyTargetCost {
    private static final FilterPermanent filter = new FilterPermanent(SubType.EQUIPMENT, "equipment attached to this creature");

    CaptainAmericaFirstAvengerUnattachCost() {
    }

    protected CaptainAmericaFirstAvengerUnattachCost(CaptainAmericaFirstAvengerUnattachCost cost) {
        super((CostImpl)cost);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        return permanent != null && !permanent.getAttachments().isEmpty();
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || player == null) {
            return this.paid;
        }
        Permanent equipment = game.getPermanentOrLKIBattlefield(this.getTargets().getFirstTarget());
        if (equipment == null || !permanent.getAttachments().contains(equipment.getId()) || !player.chooseUse(Outcome.Benefit, "Unattach " + equipment.getIdName() + "?", source, game)) {
            return false;
        }
        this.paid = permanent.removeAttachment(equipment.getId(), source, game);
        return this.paid;
    }

    public CaptainAmericaFirstAvengerUnattachCost copy() {
        return new CaptainAmericaFirstAvengerUnattachCost(this);
    }

    public void chooseTarget(Game game, Ability source, Player controller) {
        TargetPermanent chosenEquipment = new TargetPermanent(1, 1, filter, true);
        controller.choose(Outcome.Benefit, (Target)chosenEquipment, source, game);
        this.addTarget((Target)chosenEquipment);
    }

    public String getText() {
        return "Unattach an Equipment from {this}";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AttachedToSourcePredicate.instance);
    }
}

