/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.common.MorbidCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class CaravanVigilEffect
extends OneShotEffect {
    CaravanVigilEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Search your library for a basic land card, reveal it, put it into your hand, then shuffle.<br><i>Morbid</i> &mdash; You may put that card onto the battlefield instead of putting it into your hand if a creature died this turn";
    }

    private CaravanVigilEffect(CaravanVigilEffect effect) {
        super((OneShotEffect)effect);
    }

    public CaravanVigilEffect copy() {
        return new CaravanVigilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null && controller != null) {
            Card card;
            TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
            if (controller.searchLibrary(target, source, game) && (card = controller.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
                CardsImpl cards = new CardsImpl(card);
                if (MorbidCondition.instance.apply(game, source) && controller.chooseUse(Outcome.PutLandInPlay, "Put the card onto the battlefield instead?", source, game)) {
                    controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                } else {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

