/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.AttacksEachCombatStaticAbility;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CarnageCrimsonChaosReturnEffect
extends OneShotEffect {
    CarnageCrimsonChaosReturnEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return target creature card with mana value 3 or less from your graveyard to the battlefield. It gains \"This creature attacks each combat if able\" and \"When this creature deals combat damage to a player, sacrifice it.\"";
    }

    protected CarnageCrimsonChaosReturnEffect(CarnageCrimsonChaosReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public CarnageCrimsonChaosReturnEffect copy() {
        return new CarnageCrimsonChaosReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(source.getFirstTarget());
        if (card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        AttacksEachCombatStaticAbility attacksEachTurnAbility = new AttacksEachCombatStaticAbility();
        DealsCombatDamageToAPlayerTriggeredAbility damageTriggerAbility = new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new SacrificeSourceEffect());
        GainAbilityTargetEffect effectOne = new GainAbilityTargetEffect((Ability)attacksEachTurnAbility, Duration.WhileOnBattlefield);
        effectOne.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        GainAbilityTargetEffect effectTwo = new GainAbilityTargetEffect((Ability)damageTriggerAbility, Duration.WhileOnBattlefield);
        effectTwo.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addEffect((ContinuousEffect)effectOne, source);
        game.addEffect((ContinuousEffect)effectTwo, source);
        return true;
    }
}

