/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class CarpetOfFlowersEffect
extends ManaEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("Island ");

    CarpetOfFlowersEffect() {
        this.staticText = "you may add X mana of any one color, where X is the number of Islands target opponent controls";
    }

    private CarpetOfFlowersEffect(CarpetOfFlowersEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        int count;
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game != null && (count = game.getBattlefield().count((FilterPermanent)filter, source.getTargets().getFirstTarget(), source, game)) > 0) {
            netMana.add(Mana.AnyMana((int)count));
        }
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        int count;
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        ChoiceColor choice = new ChoiceColor();
        if (controller != null && controller.choose(Outcome.Benefit, (Choice)choice, game) && (count = game.getBattlefield().count((FilterPermanent)filter, source.getTargets().getFirstTarget(), source, game)) > 0) {
            switch (choice.getChoice()) {
                case "Black": {
                    mana.setBlack(count);
                    break;
                }
                case "Blue": {
                    mana.setBlue(count);
                    break;
                }
                case "Red": {
                    mana.setRed(count);
                    break;
                }
                case "Green": {
                    mana.setGreen(count);
                    break;
                }
                case "White": {
                    mana.setWhite(count);
                    break;
                }
            }
        }
        return mana;
    }

    public CarpetOfFlowersEffect copy() {
        return new CarpetOfFlowersEffect(this);
    }

    static {
        filter.add((Predicate)SubType.ISLAND.getPredicate());
        filter.add((Predicate)CardType.LAND.getPredicate());
    }
}

