/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class CarthTheLionLoyaltyCostEffect
extends CostModificationEffectImpl {
    CarthTheLionLoyaltyCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Planeswalkers' loyalty abilities you activate cost an additional +1 to activate";
    }

    private CarthTheLionLoyaltyCostEffect(CarthTheLionLoyaltyCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public CarthTheLionLoyaltyCostEffect copy() {
        return new CarthTheLionLoyaltyCostEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        if (abilityToModify instanceof LoyaltyAbility) {
            ((LoyaltyAbility)abilityToModify).increaseLoyaltyCost(1);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof LoyaltyAbility && abilityToModify.getControllerId().equals(source.getControllerId());
    }
}

