/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CaseTheJointEffect
extends OneShotEffect {
    CaseTheJointEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then look at the top card of each player's library";
    }

    private CaseTheJointEffect(CaseTheJointEffect effect) {
        super((OneShotEffect)effect);
    }

    public CaseTheJointEffect copy() {
        return new CaseTheJointEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            controller.lookAtCards(source, "Top card of " + player.getName() + "'s library", (Cards)new CardsImpl(card), game);
        }
        return true;
    }
}

