/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledEnchantmentPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class CataclysmEffect
extends OneShotEffect {
    CataclysmEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Each player chooses from among the permanents they control an artifact, a creature, an enchantment, and a land, then sacrifices the rest";
    }

    private CataclysmEffect(CataclysmEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> chosen = new ArrayList<Permanent>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            TargetControlledPermanent target1 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledArtifactPermanent(), true);
            TargetControlledPermanent target2 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledCreaturePermanent(), true);
            TargetControlledPermanent target3 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledEnchantmentPermanent(), true);
            TargetControlledPermanent target4 = new TargetControlledPermanent(1, 1, (FilterControlledPermanent)new FilterControlledLandPermanent(), true);
            if (target1.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target1.isChosen(game) && target1.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target1, source, game);
                }
                Permanent artifact = game.getPermanent(target1.getFirstTarget());
                if (artifact != null) {
                    chosen.add(artifact);
                }
                target1.clearChosen();
            }
            if (target2.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target2.isChosen(game) && target2.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target2, source, game);
                }
                Permanent creature = game.getPermanent(target2.getFirstTarget());
                if (creature != null) {
                    chosen.add(creature);
                }
                target2.clearChosen();
            }
            if (target3.canChoose(player.getId(), source, game)) {
                while (player.canRespond() && !target3.isChosen(game) && target3.canChoose(player.getId(), source, game)) {
                    player.chooseTarget(Outcome.Benefit, (Target)target3, source, game);
                }
                Permanent enchantment = game.getPermanent(target3.getFirstTarget());
                if (enchantment != null) {
                    chosen.add(enchantment);
                }
                target3.clearChosen();
            }
            if (!target4.canChoose(player.getId(), source, game)) continue;
            while (player.canRespond() && !target4.isChosen(game) && target4.canChoose(player.getId(), source, game)) {
                player.chooseTarget(Outcome.Benefit, (Target)target4, source, game);
            }
            Permanent land = game.getPermanent(target4.getFirstTarget());
            if (land != null) {
                chosen.add(land);
            }
            target4.clearChosen();
        }
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents()) {
            if (chosen.contains(permanent)) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }

    public CataclysmEffect copy() {
        return new CataclysmEffect(this);
    }
}

