/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SpellAbilityCastMode;
import mage.game.Game;
import mage.util.CardUtil;

class CatalystStoneCostRaiseEffect
extends CostModificationEffectImpl {
    CatalystStoneCostRaiseEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.INCREASE_COST);
        this.staticText = "Flashback costs your opponents pay cost {2} more";
    }

    protected CatalystStoneCostRaiseEffect(CatalystStoneCostRaiseEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility && game.getOpponents(source.getControllerId()).contains(abilityToModify.getControllerId())) {
            return SpellAbilityCastMode.FLASHBACK.equals((Object)((SpellAbility)abilityToModify).getSpellAbilityCastMode());
        }
        return false;
    }

    public CatalystStoneCostRaiseEffect copy() {
        return new CatalystStoneCostRaiseEffect(this);
    }
}

