/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.LinkedHashSet;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SpellAbilityCastMode;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CatalystStoneCostReductionEffect
extends CostModificationEffectImpl {
    CatalystStoneCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Flashback costs you pay cost {2} less";
    }

    protected CatalystStoneCostReductionEffect(CatalystStoneCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            Mana mana = abilityToModify.getManaCostsToPay().getMana();
            int reduceMax = mana.getGeneric();
            if (reduceMax > 2) {
                reduceMax = 2;
            }
            if (reduceMax > 0) {
                int reduce;
                if (game.inCheckPlayableState()) {
                    reduce = reduceMax;
                } else {
                    ChoiceImpl choice = new ChoiceImpl(true);
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (int i = 0; i <= reduceMax; ++i) {
                        set.add(String.valueOf(i));
                    }
                    choice.setChoices(set);
                    choice.setMessage("Reduce flashback cost");
                    if (controller.choose(Outcome.Benefit, (Choice)choice, game)) {
                        reduce = Integer.parseInt(choice.getChoice());
                    } else {
                        return false;
                    }
                }
                CardUtil.reduceCost((Ability)abilityToModify, (int)reduce);
            }
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId())) {
            return SpellAbilityCastMode.FLASHBACK.equals((Object)((SpellAbility)abilityToModify).getSpellAbilityCastMode());
        }
        return false;
    }

    public CatalystStoneCostReductionEffect copy() {
        return new CatalystStoneCostReductionEffect(this);
    }
}

