/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CauldronDancePutCreatureFromHandOntoBattlefieldEffect
extends OneShotEffect {
    private static final String CHOICE_TEXT = "Put a creature card from your hand onto the battlefield?";

    public CauldronDancePutCreatureFromHandOntoBattlefieldEffect() {
        super(Outcome.Benefit);
        this.staticText = "You may put a creature card from your hand onto the battlefield. That creature gains haste. Its controller sacrifices it at the beginning of the next end step";
    }

    private CauldronDancePutCreatureFromHandOntoBattlefieldEffect(CauldronDancePutCreatureFromHandOntoBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public CauldronDancePutCreatureFromHandOntoBattlefieldEffect copy() {
        return new CauldronDancePutCreatureFromHandOntoBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInHand target;
            if (controller.chooseUse(Outcome.PutCreatureInPlay, CHOICE_TEXT, source, game) && controller.choose(Outcome.PutCreatureInPlay, (Target)(target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE)), source, game)) {
                Card card = game.getCard(target.getFirstTarget());
                if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
                    Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                    if (permanent != null) {
                        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
                        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                        game.addEffect((ContinuousEffect)effect, source);
                        SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("sacrifice " + card.getName(), source.getControllerId());
                        sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                    }
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

