/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AdamantCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;

class CauldronsGiftEffect
extends OneShotEffect {
    CauldronsGiftEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Adamant</i> &mdash; If at least three black mana was spent to cast this spell, mill four cards. <br>You may choose a creature card in your graveyard. If you do, return it to the battlefield with an additional +1/+1 counter on it.";
    }

    private CauldronsGiftEffect(CauldronsGiftEffect effect) {
        super((OneShotEffect)effect);
    }

    public CauldronsGiftEffect copy() {
        return new CauldronsGiftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (AdamantCondition.BLACK.apply(game, source)) {
            player.millCards(4, source, game);
        }
        if (player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) == 0 || !player.chooseUse(this.outcome, "Choose a creature card in your graveyard to return to the battlefield?", source, game)) {
            return true;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Cards)player.getGraveyard(), (TargetCard)target, source, game)) {
            return true;
        }
        Card card = game.getCard(target.getFirstTarget());
        if (card != null) {
            Counters countersToAdd = new Counters(new Counter[0]);
            countersToAdd.addCounter(CounterType.P1P1.createInstance());
            game.setEnterWithCounters(card.getId(), countersToAdd);
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        return true;
    }

    public Condition getCondition() {
        return AdamantCondition.BLACK;
    }
}

