/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.condition.IntCompareCondition;
import mage.abilities.dynamicvalue.AdditiveDynamicValue;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;

class CavernousMawCondition
extends IntCompareCondition {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.CAVE, "other Caves you control");
    private static final FilterCard filterCard = new FilterCard("Cave cards");
    private static final DynamicValue xValue;
    static Hint hint;

    CavernousMawCondition() {
        super(ComparisonType.OR_GREATER, 3);
    }

    protected int getInputValue(Game game, Ability source) {
        return xValue.calculate(game, source, null);
    }

    public String toString() {
        return "if the number of other Caves you control plus the number of Cave cards in your graveyard is three or greater";
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
        filterCard.add((Predicate)SubType.CAVE.getPredicate());
        xValue = new AdditiveDynamicValue(new DynamicValue[]{new PermanentsOnBattlefieldCount(filter, null), new CardsInControllerGraveyardCount(filterCard)});
        hint = new ValueHint("Caves count", xValue);
    }
}

