/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreatureSpell;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class CeaseFireEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterCreatureSpell filter = new FilterCreatureSpell();

    public CeaseFireEffect() {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.staticText = "Target player can't cast creature spells this turn";
    }

    private CeaseFireEffect(CeaseFireEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CeaseFireEffect copy() {
        return new CeaseFireEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast creature spells this turn (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell;
        return event.getPlayerId().equals(this.getTargetPointer().getFirst(game, source)) && filter.match((Object)(spell = game.getStack().getSpell(event.getSourceId())), game);
    }
}

