/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CecilyHauntedMageEffect
extends OneShotEffect {
    CecilyHauntedMageEffect() {
        super(Outcome.Benefit);
        this.staticText = "you draw a card and you lose 1 life. Then if you have eleven or more cards in your hand, you may cast an instant or sorcery spell from your hand without paying its mana cost";
    }

    private CecilyHauntedMageEffect(CecilyHauntedMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public CecilyHauntedMageEffect copy() {
        return new CecilyHauntedMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        player.loseLife(1, game, source, false);
        return player.getHand().size() < 11 || CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)player.getHand().copy(), (FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY);
    }
}

