/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class CelebrateTheHarvestEffect
extends OneShotEffect {
    CelebrateTheHarvestEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to X basic land cards, where X is the number of different powers among creatures you control. Put those cards onto the battlefield tapped, then shuffle";
    }

    private CelebrateTheHarvestEffect(CelebrateTheHarvestEffect effect) {
        super((OneShotEffect)effect);
    }

    public CelebrateTheHarvestEffect copy() {
        return new CelebrateTheHarvestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int powerCount = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), source, game).stream().filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).distinct().map(x -> 1).sum();
        TargetCardInLibrary target = new TargetCardInLibrary(0, powerCount, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl();
        target.getTargets().stream().map(cardId -> player.getLibrary().getCard(cardId, game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
        player.shuffleLibrary(source, game);
        return true;
    }
}

