/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CelestialConvergenceEffect
extends OneShotEffect {
    CelestialConvergenceEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "If there are no omen counters on {this}, the player with the highest life total wins the game. If two or more players are tied for highest life total, the game is a draw";
    }

    private CelestialConvergenceEffect(CelestialConvergenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CelestialConvergenceEffect copy() {
        return new CelestialConvergenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (sourcePermanent == null || controller == null || sourcePermanent.getCounters(game).getCount(CounterType.OMEN) > 0) {
            return false;
        }
        HashMap playerMap = new HashMap();
        game.getState().getPlayersInRange(controller.getId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEach(player -> playerMap.computeIfAbsent(player.getLife(), x -> new HashSet()).add(player.getId()));
        int highLife = playerMap.keySet().stream().mapToInt(x -> x).max().orElse(Integer.MIN_VALUE);
        if (((Set)playerMap.get(highLife)).size() > 1) {
            game.setDraw(controller.getId());
            return true;
        }
        Player winner = game.getPlayer((UUID)((Set)playerMap.get(highLife)).iterator().next());
        if (winner != null) {
            winner.won(game);
        }
        return true;
    }
}

