/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CelestialMantleEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CelestialMantleAbility
extends TriggeredAbilityImpl {
    public CelestialMantleAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CelestialMantleEffect());
    }

    private CelestialMantleAbility(CelestialMantleAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CelestialMantleAbility copy() {
        return new CelestialMantleAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent p = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && p != null && p.getAttachments().contains(this.getSourceId());
    }

    public String getRule() {
        return "Whenever enchanted creature deals combat damage to a player, double its controller's life total.";
    }
}

