/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.Card;
import mage.cards.c.CemeteryDesecratorRemoveCountersEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetOpponentsCreaturePermanent;

class CemeteryDesecratorEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("another card from a graveyard");
    private static final String triggerText = "choose one &mdash;<br>&bull  Remove X counters from target permanent, where X is the mana value of the exiled card.<br>&bull  Target creature an opponent controls gets -X/-X until end of turn, where X is the mana value of the exiled card.";

    public CemeteryDesecratorEffect() {
        super(Outcome.Exile);
        this.staticText = "exile another card from a graveyard. When you do, choose one &mdash;<br>&bull  Remove X counters from target permanent, where X is the mana value of the exiled card.<br>&bull  Target creature an opponent controls gets -X/-X until end of turn, where X is the mana value of the exiled card.";
    }

    private CemeteryDesecratorEffect(CemeteryDesecratorEffect effect) {
        super((OneShotEffect)effect);
    }

    public CemeteryDesecratorEffect copy() {
        return new CemeteryDesecratorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInGraveyard target = new TargetCardInGraveyard(filter);
            target.withNotTarget(true);
            controller.choose(this.outcome, (Target)target, source, game);
            Card card = game.getCard(target.getFirstTarget());
            if (card != null) {
                int manaValue = card.getManaValue();
                if (controller.moveCards(card, Zone.EXILED, source, game)) {
                    ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new CemeteryDesecratorRemoveCountersEffect(manaValue), false, triggerText);
                    ability.addTarget((Target)new TargetPermanent());
                    Mode mode = new Mode((Effect)new BoostTargetEffect(-manaValue, -manaValue, Duration.EndOfTurn).setText("Target creature an opponent controls gets -X/-X until end of turn, where X is the mana value of the exiled card"));
                    mode.addTarget((Target)new TargetOpponentsCreaturePermanent());
                    ability.addMode(mode);
                    game.fireReflexiveTriggeredAbility(ability, source);
                    return true;
                }
            }
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

