/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class CemeteryGatekeeperTriggeredAbility
extends TriggeredAbilityImpl {
    public CemeteryGatekeeperTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(2, true, "that player"));
        this.setTriggerPhrase("Whenever a player plays a land or casts a spell, if it shares a card type with the exiled card, ");
    }

    private CemeteryGatekeeperTriggeredAbility(CemeteryGatekeeperTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CemeteryGatekeeperTriggeredAbility copy() {
        return new CemeteryGatekeeperTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Effect effect = (Effect)this.getEffects().get(0);
        effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        effect.setValue("targetId", (Object)event.getTargetId());
        effect.setValue("eventType", (Object)event.getType());
        effect.setValue("exileId", (Object)CardUtil.getExileZoneId((Game)game, (UUID)this.sourceId, (int)game.getState().getZoneChangeCounter(this.sourceId)));
        return true;
    }

    private boolean checkCardTypes(List<CardType> playedCardTypes, UUID exileId, Game game) {
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        if (exileZone != null) {
            for (UUID cardId : exileZone) {
                Card card = game.getCard(cardId);
                if (card == null) continue;
                for (CardType exileCardType : card.getCardType(game)) {
                    if (!playedCardTypes.contains(exileCardType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        Effect effect = (Effect)this.getEffects().get(0);
        UUID targetId = (UUID)effect.getValue("targetId");
        GameEvent.EventType eventType = (GameEvent.EventType)effect.getValue("eventType");
        UUID exileId = (UUID)effect.getValue("exileId");
        if (targetId != null && eventType != null && exileId != null) {
            if (eventType == GameEvent.EventType.LAND_PLAYED) {
                Permanent permanent = game.getPermanent(targetId);
                return permanent != null && this.checkCardTypes(permanent.getCardType(game), exileId, game);
            }
            if (eventType == GameEvent.EventType.SPELL_CAST) {
                Spell spell = game.getSpellOrLKIStack(targetId);
                return spell != null && this.checkCardTypes(spell.getCardType(game), exileId, game);
            }
        }
        return false;
    }
}

